/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson.helper;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import svenhjol.meson.Meson;
import svenhjol.meson.iface.IMesonEnum;

public class WorldHelper {
    public static ChunkGeneratorSettings chunkGeneratorSettings = null;
    public static long lastSeed;
    public static List<StructureType> temples;

    public static boolean canGenerateStructures(World world) {
        return world.func_72912_H().func_76089_r();
    }

    public static boolean canGenerateStructure(World world, StructureType structure) {
        if (chunkGeneratorSettings == null) {
            return false;
        }
        switch (structure) {
            case STRONGHOLD: {
                return WorldHelper.chunkGeneratorSettings.field_177833_u;
            }
            case MINESHAFT: {
                return WorldHelper.chunkGeneratorSettings.field_177829_w;
            }
            case MANSION: {
                return WorldHelper.chunkGeneratorSettings.field_191077_z;
            }
            case VILLAGE: {
                return WorldHelper.chunkGeneratorSettings.field_177831_v;
            }
            case JUNGLE_PYRAMID: 
            case DESERT_PYRAMID: 
            case SWAMP_HUT: 
            case IGLOO: {
                return WorldHelper.chunkGeneratorSettings.field_177854_x;
            }
        }
        return true;
    }

    public static BlockPos getNearestStronghold(World world, BlockPos chunk) {
        return WorldHelper.getNearestStructure(world, chunk, "Stronghold");
    }

    public static BlockPos getNearestVillage(World world, BlockPos chunk) {
        return WorldHelper.getNearestStructure(world, chunk, "Village");
    }

    public static BlockPos getNearestStructure(World world, BlockPos chunk, String structure) {
        return ((WorldServer)world).func_72863_F().func_180513_a(world, structure, chunk, false);
    }

    public static BlockPos getNearestStructure(World world, BlockPos chunk, StructureType type) {
        int offset = 1000;
        if (world.field_72995_K) {
            return null;
        }
        if (temples.contains(type)) {
            for (int dist = 0; dist < 50; ++dist) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        boolean found;
                        int xx = x * offset + x * dist * offset;
                        int zz = z * offset + z * dist * offset;
                        BlockPos tryPos = chunk.func_177982_a(xx, 0, zz);
                        BlockPos templePos = WorldHelper.getNearestStructure(world, tryPos, "Temple");
                        if (templePos == null) continue;
                        Biome biome = world.func_180494_b(templePos);
                        switch (type) {
                            case SWAMP_HUT: {
                                found = biome == Biomes.field_76780_h;
                                break;
                            }
                            case IGLOO: {
                                found = biome == Biomes.field_76774_n || biome == Biomes.field_150584_S;
                                break;
                            }
                            case DESERT_PYRAMID: {
                                found = biome == Biomes.field_76769_d || biome == Biomes.field_76786_s;
                                break;
                            }
                            case JUNGLE_PYRAMID: {
                                found = biome == Biomes.field_76782_w || biome == Biomes.field_76792_x;
                                break;
                            }
                            default: {
                                found = true;
                            }
                        }
                        if (!found) continue;
                        Meson.debug("WorldHelper: Found structure " + type + " at " + tryPos);
                        return templePos;
                    }
                }
            }
            Meson.debug("WorldHelper: Failed to find structure " + type);
            return null;
        }
        return WorldHelper.getNearestStructure(world, chunk, type.getCapitalizedName());
    }

    public static long getNearestVillageSeed(World world, BlockPos chunk) {
        BlockPos nearest = WorldHelper.getNearestVillage(world, chunk);
        long seed = 0L;
        if (nearest != null) {
            seed = nearest.toString().hashCode();
        }
        return seed;
    }

    public static double getDistanceSq(BlockPos pos1, BlockPos pos2) {
        double d0 = pos1.func_177958_n();
        double d1 = pos1.func_177952_p();
        double d2 = d0 - (double)pos2.func_177958_n();
        double d3 = d1 - (double)pos2.func_177952_p();
        return d2 * d2 + d3 * d3;
    }

    public static ChunkPos getChunkPos(BlockPos pos) {
        return new ChunkPos(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public static void populateWorldSettings(World world) {
        if (!world.field_72995_K) {
            long seed = world.func_72912_H().func_76063_b();
            if (lastSeed == seed) {
                return;
            }
            lastSeed = seed;
            String generatorOptions = world.func_72912_H().func_82571_y();
            chunkGeneratorSettings = ChunkGeneratorSettings.Factory.func_177865_a((String)generatorOptions).func_177864_b();
            Meson.log(WorldHelper.chunkGeneratorSettings.field_177833_u);
        }
    }

    static {
        temples = new ArrayList<StructureType>();
        temples.add(StructureType.SWAMP_HUT);
        temples.add(StructureType.DESERT_PYRAMID);
        temples.add(StructureType.JUNGLE_PYRAMID);
        temples.add(StructureType.IGLOO);
    }

    public static enum StructureType implements IMesonEnum
    {
        VILLAGE,
        MINESHAFT,
        SWAMP_HUT,
        DESERT_PYRAMID,
        JUNGLE_PYRAMID,
        IGLOO,
        STRONGHOLD,
        MANSION;

    }
}

